
-- Wait
-- id: player id
-- mode: switch to this mode
function fai_wait(id,mode)
        -- check timer
        if vai_timer[id]>0 then
                -- decrease
                vai_timer[id]=vai_timer[id]-1
        else
                -- switch mode
                vai_mode[id]=mode
        end
end

function fai_wait2(id,mode)
        -- check timer
        if vai_timer[id]>0 then
                -- decrease
                vai_timer2[id]=vai_timer2[id]-1
        else
                -- switch mode
                vai_mode[id]=mode
        end
end

-- Angle Delta
-- a1: angle 1
-- a2: angle 2
function fai_angledelta(a1,a2)
        local d=(a2-a1)%360
        if d<-180 then d=d+360 end
        if d>180 then d=d-360 end
        return d
end

-- Angle to
-- x1|y1: position 1
-- x2|y2: position 2
function fai_angleto(x1,y1,x2,y2)
        return math.deg(math.atan2(x2-x1,y1-y2))
end

-- Checks if table t has element e
-- t: table
-- e: element
function fai_contains(t,e)
        for _, value in pairs(t) do
                if value == e then
                        return true
                end
        end
        return false
end

-- Check if player has item in certain slot
-- id: player id
-- slot: slot
function fai_playerslotitems(id,slot)
        local items=playerweapons(id)
        for i=1,#items do
                if itemtype(items[i],"slot")==slot then
                        return true
                end
        end
        return false
end

-- Walk Aim
-- id: player
function fai_walkaim(id)
        local x=player(id,"x")
        local y=player(id,"y")
        local angle=math.deg(math.atan2(x-vai_px[id],vai_py[id]-y))
        ai_aim(id,x+math.sin(math.rad(angle))*150,y-math.cos(math.rad(angle))*150)
        if vai_px[id]~=x then vai_px[id]=x end
        if vai_py[id]~=y then vai_py[id]=y end
end

-- Enemies?
-- id1: player 1
-- id2: player 2
function fai_enemies(id1,id2)
        -- Enemies if teams are different
        if player(id1,"team")~=player(id2,"team") then
                return true
        -- Enemies if game mode is deathmatch
        elseif vai_set_gm==1 then
                return true
        end
        -- Otherwise: No Enemies
        return false
end

-- Get random (living) teammate
-- id1: random mate of this player (player id)
function fai_randommate(id)
        -- Get Team
        local team=player(id,"team")
        if team>2 then team=2 end
        -- Count
        local players=player(0,"team"..team.."living")
        -- Get Random
        if #players==0 then
                return 0
        end
        for i=1,10 do
                local randid=math.random(1,#players)
                if players[randid]~=id then
                        return players[randid]
                end
        end
        -- No mate found
        return 0
end

function fai_randomreload(id)
if vai_mode[id]~=4 and vai_mode[id]~=5 then
if vai_reload[id]==1 and math.random(1,50)==1 then
ai_reload(id)
vai_reload[id]=0
end
end
end

function side_y(x1,y1,x2,y2)
if ((x1-x2)^2>(y1-y2)^2) then
return 16
else
if (y1-y2)>0 then
return 35
elseif (y1-y2)<0 then
return -3
end
end
end

function side_x(x1,y1,x2,y2)
if ((y1-y2)^2>(x1-x2)^2) then
return 16
else
if (x1-x2)>0 then
return 35
elseif (x1-x2)<0 then
return -3
end
end
end

function fai_spray(id)
if math.random(1,10)==1 then
ai_spray(id)
end
end


function fai_weapon(id,weapon)
     local weapons = playerweapons(id)
     for i = 1, #weapons do
          if weapons[i] == weapon then
               return true
          end
     end
     return false
end

function fai_randommenemy(id)
        local team=player(id,"team")
        if team==1 then team=2 elseif team==2 then team=1 end
        if team>2 then team=2 end
        -- Count
        local players=player(0,"team"..team.."living")
        -- Get Random
        if #players==0 then
                return 0
        end
        for i=1,10 do
                local randid=math.random(1,#players)
                if players[randid]~=id then
                        return players[randid]
                end
        end
        -- No mate found
        return 0
end


function fai_dwalkable(id,x,y)
if ai_goto(id,x-1,y-1)~=0 then
return 1
elseif ai_goto(id,x,y-1)~=0 then
return 2
elseif ai_goto(id,x+1,y-1)~=0 then
return 3
elseif ai_goto(id,x+1,y)~=0 then
return 4
elseif ai_goto(id,x+1,y+1)~=0 then
return 5
elseif ai_goto(id,x,y+1)~=0 then
return 6
elseif ai_goto(id,x-1,y+1)~=0 then
return 7
elseif ai_goto(id,x-1,y)~=0 then
return 8
else
return 0
end
end

function fai_getbuilding(team,type)
local b =object(0,"table")
if #b~=0 then
local l = 0
for i = 1, #b do
local oteam = object(b[i],"team")
if oteam==team and object(b[i],"type")==7 then
l=b[i]
end
end
if l==0 then
return 0
else
return l
end
else
return 0
end
end
