MenuObject = {}
function createMenu(str,func)
	local s = str:split(",")
	local big = false
	local title = s[1]
	local button = {}
	for i = 2, #s do button[i-1] = s[i] end

	if string.sub(s[1],string.len(s[1])-1,string.len(s[1])) == "@b" then
		big = true
		s[1] = string.sub(s[1],1,string.len(s[1])-2)
	end

	local m = {
		title = title,
		button = button,
		page = {},
		buttonPage = {},
		func = func,
		buttonFunc = {},
		big = big
	}

	function m.updatePages()
		local pos = 1
		local slot = 1
		local page = 1
		while pos <= #button do
			if pos > 8 and slot > 7 then
				slot = 1
				page = page + 1
			end

			m.page[page] = m.page[page] or {}
			if (slot <= 8 and page == 1) or (slot <= 7 and page > 1) then
				m.page[page][slot] = pos
				m.buttonPage[pos] = page
			end

			slot = slot + 1
			pos = pos + 1
		end
	end

	function m.getPage(page)
		local info = m.title.." [Page "..page.."]"
		if m.big then info = info.."@b" end
		local i = 1
		while m.page[page][i] do
			info = info..","..m.getButtonText(m.page[page][i])
			i = i + 1
		end
		if page == 1 and i <= 8 then
			for i = i, 8 do
				info = info..","
			end
		elseif page > 1 and i <= 7 then
			for i = i, 7 do
				info = info..","
			end
		end
		local nextPage,backPage = "",""
		if m.page[page+1] then
			nextPage = ",Next Page|Page "..page+1
		end
		if page > 1 then
			backPage = ",Back Page|Page "..(page-1)
		end
		return info..backPage..nextPage
	end

	function m.getButtonText(b)
		local str = m.button[b]
		if m.buttonFunc[b] then str = m.buttonFunc[b]() or str end
		return str
	end

	function m.setSlot(button,newSlot)
		m.button[button] = newSlot
	end

	function m.convertButton(button,page)
		return m.page[page][button]
	end

	function m.getButtonPage(button)
		return buttonPage[button]
	end

	function m.openTo(id,page)
		menu(id, m.getPage(page))
	end
	m.updatePages()

	MenuObject[m.title] = m
	return m
end

-- yourMenuName = CreateMenu("Your Title,Button 1,Button 2,Button 3,ETC",
--	function (id,menuTitle,page,pageAsObject,button)
--	end
--)

addhook("menu","PageMenu")
function PageMenu(id,men,sel)
	local parsed = men:split("[Page ")
	if parsed[2] then
		local page = tonumber(string.sub(parsed[2],1,string.len(parsed[2])-1))
		local title = string.sub(parsed[1],1,string.len(parsed[1])-1)
		local o = MenuObject[title]
		if sel == 9 then
			o.openTo(id,page+1)
			return
		elseif sel == 8 and page > 1 then
			o.openTo(id,page-1)
			return
		end
		if o and o.func then
			o.func(id,title,page,o,o.convertButton(sel,page) or 0)
		end
	end
end
