zp_headcrab_id = ZP.CreateClass({
	Name = "Headcrab",
	Description = "HP-- Speed+- DMG+- Jump++",
	Health = 1000,
	Armor = 0,
	Speed = -10,
	Dmg = {40,50},
	Knockback = 140,
	Invisible = true,
	Jump = 10,
	JumpDelay = 500,
	ExtraWeapon = {}
})
zp_headcrab_class = ZP.Class[zp_headcrab_id]
zp_headcrab_jump_weapon = CreateItem("Headcrab Jump")

zp_headcrab_class.Image = {}
function zp_headcrab_class.Spawn(id)
	if zp_headcrab_class.Image[id] then
		freeimage(zp_headcrab_class.Image[id])
		zp_headcrab_class.Image[id] = nil
	end

	if not PLAYER[id].Nemesis and not ZP_ROUND_END then
		parse("setarmor "..id.." 206")
		zp_headcrab_class.Image[id] = image("gfx/starkkz/zombie/headcrab.bmp",1,0,200+id)
	end
end

function zp_headcrab_class.Startround()
	zp_headcrab_class.Image = {}
end

function zp_headcrab_class.Die(id)
	if zp_headcrab_class.Image[id] then
		freeimage(zp_headcrab_class.Image[id])
		zp_headcrab_class.Image[id] = nil
	end

	Sound3("npc/headcrab_die.wav",player(id,"x"),player(id,"y"),380)
	return 0
end

function zp_headcrab_class.Always(id)
	if player(id,"bot") then
		local t = vai_target[id]
		if t and t > 0 and player(t,"exists") and player(t,"health") > 0 then
			PLAYER[id].JumpAction()
		end
	end
end

function zp_headcrab_class.IgnitePain(id)
	return 0
end

function zp_headcrab_class.Hit(id,source,wpn,hpdmg,apdmg)
	return 0
end

function zp_headcrab_class.JumpMovement(id,x,y)
	for _, p in pairs(player(0,"table")) do
		if math.sqrt((x-player(p,"x"))^2 + (y-player(p,"y"))^2) < 20 then
			if player(p,"team") ~= player(id,"team") and player(p,"health") > 0 then
				ZP.Hit(p, id, zp_headcrab_jump_weapon, 50 + math.random(-5,5),0)
				PLAYER[id].Jump = 0
				Sound3("npc/headcrab_attack.wav",x,y,250)
			end
		end
	end
end
