function initArray(m,q)
	if not q then q = 0 end
	local array = {}
	for i = 1, m do
		array[i]=q
	end
	return array
end

function totable(t,match)
     local cmd = {}
     if not match then match = "[^%s]+" end
     for word in string.gmatch(t, match) do
          table.insert(cmd, word)
     end
     return cmd
end 

function gm_draw_tile(id,file)
	img2 = image(file,(player(id,"tilex")*32)+16,(player(id,"tiley")*32)+16,0)
end

function gm_draw_object(id,file)
	obj_img[obj_cnt] = image(file,player(id,"x"),player(id,"y"),1)
	obj_x[obj_cnt]=player(id,"x")
	obj_y[obj_cnt]=player(id,"y")
	obj_cnt=obj_cnt+1
end

function gm_spawn_object(id,x,y,bid)
	parse('spawnobject '..bid..' '..x..' '..y..' 0 0 '..player(id,"team")..' '..id)
end

function gm_draw_wall(id,bid,x1,y1,file)
	x2=x1*32
	y2=y1*32
	parse('spawnobject '..bid..' '..x1..' '..y1..' 0 0 '..player(id,"team")..' '..id)
	img[cnt] = image(file,x2+16,y2+16,1)
	xx[cnt] = x1
	yy[cnt] = y1
	cnt=cnt+1
end

function gm_spawn_item(id,w)
	parse('spawnitem '..w..' '..player(id,"tilex")..' '..player(id,"tiley"))
end

-----------------------------------------[ Menu Items ]-----------------------------------------

function gm_menu_items(id)
	menu(id,"GMOD - Items Menu,Pistols,Rifles,Sub Machine Guns,Shotguns,Armors,Other")
end

function gm_menu_pistols(id)
	menu(id,"GMOD - Pistols Menu,<- Back,USP,Glock,Deagle,P228,Elite,Five-Seven")
end

function gm_menu_rifles(id)
	menu(id,"GMOD - Rifles Menu,<- Back,Famas,AK-47,M4A1,SG552,Scout,AWP,G3SG1,SG550")
end

function gm_menu_submachineguns(id)
	menu(id,"GMOD - Sub Machine Guns Menu,<- Back,Mac 10,MP5,P90,UMP45,TMP")
end

function gm_menu_shotguns(id)
	menu(id,"GMOD - Shotguns Menu,<- Back,M3,XM1014")
end

function gm_menu_armors(id)
	menu(id,"GMOD - Armors Menu,<- Back,Light Armor,Medium Armor,Heavy Armor,Medic Armor,Super Armor,Stealth Suit")
end

function gm_menu_other_1(id)
	menu(id,"GMOD - Other I Menu,<- Back,Gas Grenade,Laser Mine,Mine,Gut Bomb,Chainsaw,Claw,Airstrike,Next ->")
end

function gm_menu_other_2(id)
	menu(id,"GMOD - Other II Menu,<- Back,Laser,Flamethrower,Grenade Launcher,RPG Launcher,Rocket Launcher,Portalgun,Tactical Shield,Next ->")
end

function gm_menu_other_3(id)
	menu(id,"GMOD - Other III Menu,<- Back,Kevlar+Helm,Flashbang,HE,Smoke Grenade,Defuse Kit,Night Vision,Flare,Next ->")
end

function gm_menu_other_4(id)
	menu(id,"GMOD - Other IV Menu,<- Back,Snowball,Molotov Coctail,Machete,Wrench,Medkit,Bandage,Primary Ammo,Secondary Ammo")
end

-----------------------------------------[ Menu Buildings ]-----------------------------------------

function gm_menu_buildings(id)
	menu(id,"GMOD - Building Menu,Walls,Ground,Tiles,Furniture,Objects,Road,Clear wall on your position")
end

function gm_menu_walls_1(id)
	menu(id,"GMOD - Walls I Menu,<- Back,Brick Wall 1,Brick Wall 2,Brick Wall 3,Brick Wall 4,Brick Wall 5,Metal Wall,Glass 1,Next ->")
end

function gm_menu_walls_2(id)
	menu(id,"GMOD - Walls II Menu,<- Back,Glass 2,Wall 1,Wall 2,Wall 3,Wood Wall 1,Wood Wall 2")
end

function gm_menu_ground(id)
	menu(id,"GMOD - Ground Menu,<- Back,Grass,Sand,Water,Snow")
end

function gm_menu_tiles_1(id)
	menu(id,"GMOD - Tiles I Menu,<- Back,Floor 1,Floor 2,Floor 3,Floor 4,Floor 5,Metal Floor,Outside Tile,Next ->")
end

function gm_menu_tiles_2(id)
	menu(id,"GMOD - Tiles II Menu,<- Back,Outside Tile Water,Tile Wood,Portal Tile")
end

function gm_menu_furniture(id)
	menu(id,"GMOD - Furniture Menu,<- Back,Chair 1,Chair 2,Chair 3,Table|Wall,Cooker|Wall,Toilet,Sink,Next ->")
end

function gm_menu_furniture_2(id)
	menu(id,"GMOD - Furniture Menu - 2,<- Back,Bed,TV|Walls,Computer|Walls")
end

function gm_menu_bed(id)
	menu(id,"GMOD - Bed Menu,<- Back,Bed Left,Bed Right,Bed Up,Bed Down")
end

function gm_menu_tv(id)
	menu(id,"GMOD - TV Menu,<- Back,TV Left|Wall,TV Right|Wall,TV Up|Wall,TV Down|Wall")
end

function gm_menu_computer(id)
	menu(id,"GMOD - Computer Menu,<- Back,Computer Left|Wall,Computer Right|Wall,Computer Up|Wall,Computer Down|Wall")
end

function gm_menu_objects(id)
	menu(id,"GMOD - Objects Menu,<- Back,Tree 1,Tree 2,Bush 1,Bush 2,Bush 3,Clear Object On Your Position")
end

function gm_menu_road(id)
	menu(id,"GMOD - Road Menu,<- Back,Road,Road Hor.,Road Ver.")
end

function gm_chair_1(id)
	menu(id,"GMOD - Blue Chair Menu,<- Back,Chair Left,Chair Right,Chair Up,Chair Down")
end

function gm_chair_2(id)
	menu(id,"GMOD - Red Chair Menu,<- Back,Chair Left,Chair Right,Chair Up,Chair Down")
end

function gm_chair_3(id)
	menu(id,"GMOD - Green Chair Menu,<- Back,Chair Left,Chair Right,Chair Up,Chair Down")
end

function gm_toilet(id)
	menu(id,"GMOD - Toilet Menu,<- Back,Toilet Left,Toilet Right,Toilet Up,Toilet Down")
end

function gm_sink(id)
	menu(id,"GMOD - Sink Menu,<- Back,Sink Left,Sink Right,Sink Up,Sink Down")
end

-----------------------------------------[ Menu NPC ]-----------------------------------------

function gm_menu_npc(id)
	menu(id,"GMOD NPC Menu,Create your NPC,Move your NPC,Set position of NPC to your,Set image of your NPC")
end

function gm_menu_change_npc(id)
	menu(id,"GMOD Change NPC Menu,<- Back,NPC 1,NPC 2,NPC 3")
end

function gm_menu_move_npc(id)
	menu(id,"GMOD Move NPC Menu,<- Back,Move Left,Move Right,Move Up,Move Down")
end

function npc_refresh(id)
	freeimage(npcid[id])
	npcid[id]=image(npcimg[id],npcx[id],npcy[id],1)
	imagepos(npcid[id],npcx[id],npcy[id],npcrot[id])
end

function npc_rotate(id,deg)
	npcrot[id]=deg
	npc_refresh(id)
end

function npc_create(id,x,y,rot,img)
	npcx[id]=x
	npcy[id]=y
	npcrot[id]=rot
	npcimg[id]=img
	npcid[id]=image(npcimg[id],npcx[id],npcy[id],1)
	npc_refresh(id)
end

function npc_move(id,x,y)
	npcx[id]=npcx[id]+x
	npcy[id]=npcy[id]+y
	npc_refresh(id)
end

function npc_move_up(id,pixels)
	if not pixels then pixels=16 end
	npc_move(id,0,-pixels)
	npc_rotate(id,0)
end

function npc_move_down(id,pixels)
	if not pixels then pixels=16 end
	npc_move(id,0,pixels)
	npc_rotate(id,180)
end

function npc_move_left(id,pixels)
	if not pixels then pixels=16 end
	npc_move(id,-pixels,0)
	npc_rotate(id,270)
end

function npc_move_right(id,pixels)
	if not pixels then pixels=16 end
	npc_move(id,pixels,0)
	npc_rotate(id,90)
end

--------------------------------------------[ Cars ] ---------------------------------------

function hud(id)
	if (incar[id]>0) then
		parse('hudtxt2 '..id..' 1 "000255000Car Health : '..carhp[incar[id]]..' | Car Max Speed : '..carspeed[incar[id]]..' | Car Name : '..carname[incar[id]]..'" 216 454 0')
	end
	if (incar[id]==0) then
		parse('hudtxt2 '..id..' 1 "255000000No Car" 216 454 0')
	end
end

function add_car(car_x,car_y,car_rot,car_image,car_speed,car_hp,car_name)
	carx[cars]=car_x
	cary[cars]=car_y
	carrot[cars]=car_rot
	carimage[cars]=car_image
	carspeed[cars]=car_speed
	carname[cars]=car_name
	carhp[cars]=car_hp
	draw_car(cars)
	cars=cars+1
end

function destroy_car_p(car_id)
	carx[cars]=-9999
	cary[cars]=-9999
	clear_player_car(car_id)
end

function destroy_car_c(car_id)
	carx[cars]=-9999
	cary[cars]=-9999
	clear_car(car_id)
end

function player_enter_car(car_id,player_id)
	clear_car(car_id)
	draw_player_car(car_id,player_id)
	incar[player_id]=car_id
	parse('speedmod '..player_id..' '..carspeed[car_id])
	parse('equip '..player_id..' 78')
end

function player_drop_car(car_id,player_id)
	carx[car_id]=player(player_id,"x")
	cary[car_id]=player(player_id,"y")
	carrot[car_id]=player(player_id,"rot")
	clear_player_car(car_id)
	draw_car(car_id)
	carrot[car_id]=player(player_id,"rot")
	incar[player_id]=0
	parse('speedmod '..player_id..' 0')
end

function draw_car(car_id)
	carimg[car_id] = image(carimage[car_id],carx[car_id],cary[car_id],cop)
	imagepos(carimg[car_id],carx[car_id],cary[car_id],carrot[car_id])
end

function draw_player_car(car_id,player_id)
	local g
	if cop==1 then g=200 else g=100 end
	carplayerimg[car_id]=image(carimage[car_id],1,-1,g+player_id)
end

function clear_car(car_id)
	freeimage(carimg[car_id])
end

function clear_player_car(car_id)
	freeimage(carplayerimg[car_id])
end

function car_menu(id)
	menu(id,"Car Spawn Menu,Diablo,Super-GT,BMW,Cheetah,Porshe")
end