function os.name()
	local osname
	if os.getenv then
		osname = os.getenv("OS")
	end
	if not osname then
		local fh, err = io.popen("uname -o 2>/dev/null","r")
		if fh then
			osname = fh:read()
		end
	end
	return osname or "Unknown"
end

function Millisecs()
	return os.clock() * 1000
end