if not SERVER_DATA["tempbanip"] then SERVER_DATA["tempbanip"] = {} end
if not SERVER_DATA["tempbanusgn"] then SERVER_DATA["tempbanusgn"] = {} end
if not SERVER_DATA["tempbanname"] then SERVER_DATA["tempbanname"] = {} end

function Bannable(id,source)
	if source and player(source,"exists") then
		if SERVER_RANK[USER[id]["rank"]].lvl >= SERVER_RANK[USER[source]["rank"]].lvl then
			return false
		end
	end
	return true
end

function AddTempban(id,m,source,reason)
	if not id or not player(id,"exists") then return nil end
	
	if source and player(source,"exists") then
		if SERVER_RANK[USER[id]["rank"]].lvl >= SERVER_RANK[USER[source]["rank"]].lvl then
			return ErrorMSG(source, "You can't temp ban someone that's higher/equal rank")
		end
	end
	
	if player(id,"usgn") and player(id,"usgn") > 0 then
		SERVER_DATA["tempbanusgn"][player(id,"usgn")] = m
	end
	SERVER_DATA["tempbanip"][player(id,"ip")] = m
	SERVER_DATA["tempbanname"][player(id,"name")] = m
	if reason then
		if source and player(source,"exists") then
			ServerMSG(player(source,"name").." temp. banned "..player(id,"name").." for "..reason.." ("..m.." mins.)")
		else
			ServerMSG(player(id,"name").." has been temp. banned for "..reason.." ("..m.." mins.)")
		end
	else
		if source and player(source,"exists") then
			ServerMSG(player(source,"name").." temp. banned  "..player(id,"name").." for "..m.." minutes")
		else
			ServerMSG(player(id,"name").." has been temp. banned for "..m.." minutes")
		end
	end
	parse('kick '..id..' "Temp. banned for '..m..' minutes"')
	SaveServer()
end

addhook("minute","TempbanCountdown")
function TempbanCountdown()
	for ip, minutes in pairs(SERVER_DATA["tempbanip"]) do
		SERVER_DATA["tempbanip"][ip] = SERVER_DATA["tempbanip"][ip] - 1
		if SERVER_DATA["tempbanip"][ip] <= 0 then
			SERVER_DATA["tempbanip"][ip] = nil
		end
	end
	for usgn, minutes in pairs(SERVER_DATA["tempbanusgn"]) do
		SERVER_DATA["tempbanusgn"][usgn] = SERVER_DATA["tempbanusgn"][usgn] - 1
		if SERVER_DATA["tempbanusgn"][usgn] <= 0 then
			SERVER_DATA["tempbanusgn"][usgn] = nil
		end
	end
	for name, minutes in pairs(SERVER_DATA["tempbanname"]) do
		SERVER_DATA["tempbanname"][name] = SERVER_DATA["tempbanname"][name] - 1
		if SERVER_DATA["tempbanname"][name] <= 0 then
			SERVER_DATA["tempbanname"][name] = nil
		end
	end
end

addhook("join","TempbanCheck")
function TempbanCheck(id)
	if SERVER_DATA["tempbanname"][player(id,"name")] then
		parse('kick '..id..' "Temp. banned"')
	elseif SERVER_DATA["tempbanip"][player(id,"ip")] then
		parse('kick '..id..' "Temp. banned"')
	elseif SERVER_DATA["tempbanusgn"][player(id,"usgn")] then
		parse('kick '..id..' "Temp. banned"')
	end
end