freeimage_handle = {}

function Blood(x,y,angle,move_delay,disappear_delay,dist,scale)
	local img = image("gfx/starkkz/fragments/"..math.random(1,4)..".png", 0, 0, 0)
	imagepos(img, x, y, 0)
	imagecolor(img, 200, 0, 0)
	imagescale(img, scale, scale)
	imagealpha(img, 0.8)
	
	local r = math.rad(angle)
	local tx = x + math.sin(r) * dist
	local ty = y - math.cos(r) * dist
	tween_freeimage(img, disappear_delay)
	tween_alpha(img, disappear_delay, 0)
	tween_move(img, move_delay, tx, ty)
end

function ThrowBlood(x,y,rot)
	for i = 1, 8 do
		local Angle = math.rad(rot)
		local tx = x + math.sin(Angle) * i * 3
		local ty = y - math.cos(Angle) * i * 3
		Blood(tx, ty, rot, i*40, 3000, i*5, ((9 - i)/20) + 0.8)
	end
end

function tween_freeimage(img,delay)
	freeimage_handle[img] = (os.clock() * 1000) + delay
end

function RadBetween(fromx,fromy,tox,toy)
	return math.atan2(fromy-toy,fromx-tox) - math.pi/2
end

function AngleBetween(fromx,fromy,tox,toy)
	return math.deg(RadBetween(fromx, fromy, tox, toy))
end

addhook("always","RemoveTweenImage")
function RemoveTweenImage()
	for img, t in pairs(freeimage_handle) do
		if t - (os.clock() * 1000) <= 0 then
			freeimage(img)
			freeimage_handle[img] = nil
		end
	end
end

addhook("startround_prespawn","RemoveTweenHandles")
function RemoveTweenHandles()
	freeimage_handle = {}
end