function table.find(tab,val)
	for k, v in pairs(tab) do
		if v == val then
			return k
		end
	end
end

function table.max(t)
	local index
	for k, v in pairs(t) do
		if not index or t[k] > t[index] then
			index = k
		end
	end
	return t[index], index
end

function table.merge(t,del)
	if not del then del = " " end
	local str = t[1]
	for i = 2, #t do
		str = str .. del .. t[i]
	end
	return str
end

function table.copy(t)
	local copy = {}
	for k, v in pairs(t) do
		if type(v) == "table" then
			copy[k] = table.copy(v)
		elseif type(v) == "function" then
			copy[k] = loadstring(string.dump(v))
		else
			copy[k] = v
		end
	end
	return copy
end

function table.copyover(x,y)
	for k, v in pairs(x) do
		if type(v) == "table" then
			if type(y[k]) == "table" then
				table.copyover(y[k], v)
			else
				y[k] = table.copy(v)
			end
		elseif type(v) == "function" then
			y[k] = loadstring(string.dump(v))
		else
			y[k] = v
		end
	end
end

function table.compare(t,x)
	for k, v in pairs(t) do
		if not x[k] then return false end
		if x[k] ~= t[k] then return false end
	end
	return true
end

function table.size(t)
	local n = 0
	for k, v in pairs(t) do
		n = n + 1
	end
	return  n
end

function table.firstElement(t)
	for i = 1, #t do
		if t[i] then return i end
	end
end

function table.order(t)
	local e = table.firstElement(t)
	local nt = {}
	if e then
		for i = e, #t do
			table.insert(nt, t[i])
		end
	end
	return nt
end