function Class(name)
	return function (tab)
		_G[name] = tab
		return function (extend)
			for k, v in pairs(extend) do
				CopyClass(v, tab)
			end
		end
	end
end

function CopyClass(class,o)
	for k, v in pairs(class) do
		if type(v) == "table" then
			if type(o[k]) == "table" then
				CopyClass(v, o[k])
			else
				if not o[k] then
					o[k] = CopyClass(v)
				end
			end
		elseif type(v) == "function" then
			if not o[k] then o[k] = loadstring(string.dump(v)) end
		else
			if not o[k] then o[k] = v end
		end
	end
end

function New(class)
	if not class then return nil end
	local NewClass = {}
	for k, v in pairs(class) do
		if type(v) == "table" then
			NewClass[k] = New(v)
		elseif type(v) == "function" then
			NewClass[k] = loadstring(string.dump(v))
		else
			NewClass[k] = v
		end
	end
	return NewClass
end