USGN_DEFAULTDATA["rank"] = "player"

SERVER_RANK = {}
SERVER_RANK["player"] = {prefix = "Player",r=255,g=255,b=255,lvl = 0}
SERVER_RANK["vip"] = {prefix = "Vip",r=150,g=0,b=100,lvl = 5}
SERVER_RANK["member"] = {prefix = "Member",r=0,g=50,b=255,lvl = 10}
SERVER_RANK["mod"] = {prefix = "Mod",r=150,g=150,b=150,lvl = 15}
SERVER_RANK["smod"] = {prefix = "S-Mod",r=100,g=100,b=100,lvl = 16}
SERVER_RANK["supporter"] = {prefix = "Supporter",r=100,g=0,b=100,lvl = 20}
SERVER_RANK["admin"] = {prefix = "Admin",r=0,g=255,b=255,lvl = 25}
SERVER_RANK["sadmin"] = {prefix = "S-Admin",r=0,g=200,b=200,lvl = 26}
SERVER_RANK["head-admin"] = {prefix = "Head-Admin",r=255,g=0,b=0,lvl = 30}
SERVER_RANK["owner"] = {prefix = "Owner",r=255,g=255,b=0,lvl = 35}

function RankExists(r)
	return SERVER_RANK[r] and not SERVER_RANK[r].hidden
end

function HighestLevel()
	local l = 0
	for k, v in pairs(SERVER_RANK) do
		if v.lvl > l then
			l = v.lvl
		end
	end
	return l
end

function LevelRanks(lvl)
	local r = {}
	local last
	for name, v in pairs(SERVER_RANK) do
		if v.lvl == lvl then
			if not last then
				last = name
			else
				r[last] = name
				last = name
			end
		end
	end
	return r
end

function FirstRank()
	local r
	for k, v in pairs(SERVER_RANK) do
		if RankExists(k) then
			if not r or v.lvl < SERVER_RANK[r].lvl then
				r = k
			end
		end
	end
	return r
end

function LastRank()
	local r = USGN_DEFAULTDATA["rank"]
	local n = NextRank(r)
	while n do
		r = n
		n = NextRank(r)
	end
	return r
end

function NextRank(name)
	local ranks = LevelRanks(SERVER_RANK[name].lvl)
	if ranks[name] then
		return ranks[name]
	else
		local lowestName
		for k, v in pairs(SERVER_RANK) do
			if RankExists(k) then
				if v.lvl > SERVER_RANK[name].lvl and k ~= name then
					if not lowestName and not v.hidden then
						lowestName = k
					elseif v.lvl < SERVER_RANK[lowestName].lvl and not v.hidden then
						lowestName = k
					end
				end
			end
		end
		return lowestName
	end
end

function RankList()
	local _list = {}
	local _last = USGN_DEFAULTDATA["rank"]
	while true do
		if _last then
			table.insert(_list, _last)
		else
			break
		end
		
		_last = NextRank(_last)
	end
	return _list
end