PlayerMovePlace = {}

function move_player(id,delay,x,y)
	PlayerMovePlace[id] = {
		x = x,
		y = y,
		start = Millisecs(),
		finish = Millisecs() + delay,
		delay = delay,
		startx = player(id,"x"),
		starty = player(id,"y"),
	}
end

addhook("always","PlayerSetpos")
function PlayerSetpos()
	for id, m in pairs(PlayerMovePlace) do
		if player(id, "exists") and player(id, "health") > 0 and m.finish - Millisecs() > 0 then
			local percent = (m.finish - Millisecs())/m.delay
			local Dist = AI.GetDist(m.startx, m.starty, m.x, m.y) * (1 - percent)
			local Angle = AI.GetAngle(m.startx, m.starty, m.x, m.y)
			
			local x = m.startx + math.sin(Angle) * Dist
			local y = m.starty - math.cos(Angle) * Dist
			
			if x > 0 and y > 0 and x < (map("xsize")+1)*32 and y < (map("ysize")+1)*32 then
				parse("setpos "..id.." "..x.." "..y)
			end
			
			if Dist == 0 then PlayerMovePlace[id] = nil end
		else
			PlayerMovePlace[id] = nil
		end
	end
end