-- Mouse menu
mouse_menu = CreateMenu("Mouse actions")
function mouse_menu:click(id,b)
	USERTEMP[id]["mousefunction"] = b
	if EXTRA_MOUSEFUNCTION[b] and EXTRA_MOUSEFUNCTION[b]["func"] then
		EXTRA_MOUSEFUNCTION[b]["func"](id)
	end
end

function mouse_menu:getcustombutton(b,id,d)
	if EXTRA_MOUSEFUNCTION[b] then
		return EXTRA_MOUSEFUNCTION[b]["name"]
	end
end

AddMenu(mouse_menu, 20)

EXTRA_MOUSEFUNCTION = {}
EXTRA_MOUSEFUNCTION_COUNT = 1
function CreateMouseFunc(name,event,func)
	EXTRA_MOUSEFUNCTION[EXTRA_MOUSEFUNCTION_COUNT] = {name = name,func = func,event = event}
	EXTRA_MOUSEFUNCTION_COUNT = EXTRA_MOUSEFUNCTION_COUNT + 1
end

EXTRA_MOUSEEVENT = {}
EXTRA_MOUSEEVENT_COUNT = 1
function CreateMouseEvent(func)
	EXTRA_MOUSEEVENT_COUNT = EXTRA_MOUSEEVENT_COUNT + 1
	EXTRA_MOUSEEVENT[EXTRA_MOUSEEVENT_COUNT] = func
	return EXTRA_MOUSEEVENT_COUNT
end

addhook("use","CallMouse")
function CallMouse(id,event)
	if event == 0 then
		local func = USERTEMP[id]["mousefunction"]
		if EXTRA_MOUSEFUNCTION[func] then
			USERTEMP[id]["mouseevent"] = EXTRA_MOUSEFUNCTION[func]["event"]
		end
	end
end

addhook("always","RequestMouse")
function RequestMouse()
	for _, id in pairs(player(0,"table")) do
		if USERTEMP[id]["mouseevent"] then
			reqcld(id, 2)
		end
	end
end

addhook("clientdata","ReceiveMouse")
function ReceiveMouse(id,mode,x,y)
	if not id or not mode or not x or not y then return end

	local event = USERTEMP[id]["mouseevent"]
	if event then
		if EXTRA_MOUSEEVENT[event] then
			EXTRA_MOUSEEVENT[event](id, x, y)
		end
	end
end