AddTransferFile("sfx/nuke.ogg")

CreateChat "!nuke" "<x> <y> <range>" (35) [[
	if args >= 4 then
		local x = tonumber(s[2])
		local y = tonumber(s[3])
		local range = tonumber(s[4])
		
		NukePosition(x, y, range)
	end
]]

CreateChat "!nukeplayer" "<id> <range>" (35) [[
	if args >= 3 then
		local p = tonumber(s[2])
		local range = tonumber(s[3])
		
		if p and player(p,"exists") and player(p,"health") > 0 then
			NukePosition(player(p,"x"), player(p,"y"), range, p)
		end
	end
]]

function NukePosition(x,y,range,pl)
	if x and y and range then
		local img = image("gfx/sprites/flare3.bmp", 0, 0, 3)
		imagepos(img, x, y, 0)
		imageblend(img, 1)
		imagecolor(img, 255, 255, 0)
		imagescale(img, range/95, range/95)
		
		tween_scale(img, 3000, range/95 * 2, range/95 * 2)
		tween_alpha(img, 5000, 0)
		AddTimer(6000, true, freeimage, img)
		Sound3("nuke.ogg", x, y, range)
		
		for _, id in pairs(player(0,"table")) do
			if AI.GetDist(player(id,"x"), player(id,"y"), x, y) < range then
				if not pl or (pl and pl ~= id) then
					local Angle = AI.GetAngle(x, y, player(id,"x"), player(id,"y"))
					local d = range - AI.GetDist(x, y, player(id,"x"), player(id,"y"))
					
					local tx = player(id,"x") + math.sin(Angle) * d
					local ty = player(id,"y") - math.cos(Angle) * d
					
					local Dist = AI.MaxLine(player(id,"x"), player(id,"y"), tx, ty)
					local tax = player(id,"x") + math.sin(Angle) * Dist
					local tay = player(id,"y") - math.cos(Angle) * Dist
					move_player(id, 500, tax, tay)
					
					for i = 1, 5 do
						AddTimer(i*100, true, HitPlayer, id, i*10 + math.random(-5,5))
					end
				end
			end
		end
	end
end