CreateChat "!mute" "<id> <minutes> [reason]" (15)[[
	if args >= 3 then
		local p = tonumber(s[2])
		local mins = tonumber(s[3])
		local reason; if args >= 4 then reason = string.sub(txt, pos[4]) end
		
		if p and player(p,"exists") and mins then
			AddTempMute(p, mins, reason)
		elseif not p then
			mute_menu:OpenPlayer(id, 1)
		end
	end
]]

CreateChat "!unmute" "<id>" (15)[[
	local p = tonumber(s[2])
	if p and player(p,"exists") then
		RemoveTempMute(p)
	elseif not p then
		mute_menu:OpenPlayer(id, 1)
	end
]]

function AddTempMute(id,mins,reason)
	if player(id,"exists") then
		USERIP[player(id,"ip")]["mute"] = mins
		if reason then
			ServerMSG(player(id,"name").." has been muted for "..reason.." ("..mins.." mins.)")
		else
			ServerMSG(player(id,"name").." has been muted for "..mins.." minutes")
		end
	end
end

function RemoveTempMute(id)
	if player(id,"exists") then
		USERIP[player(id,"ip")]["mute"] = nil
		ServerMSG(player(id,"name").." has been unmuted")
	end
end

mute_menu = CreateMenu("Mute/Unmute players")
function mute_menu:getcustombutton(b,id,def)
	if player(b,"exists") then
		if USERIP[player(b,"ip")]["mute"] then
			return player(b,"name").."|Unmute"
		else
			return player(b,"name").."|Mute"
		end
	end
end

function mute_menu:click(id,b,page)
	if player(b,"exists") then
		if USERIP[player(b,"ip")]["mute"] then
			RemoveTempMute(b)
		else
			AddTempMute(b, 10)
		end
	end
end

CreateChatAttachment(
	function (id,txt)
		if USERIP[player(id,"ip")]["mute"] and USERIP[player(id,"ip")]["mute"] > 0 then
			ErrorMSG(id, "You're muted, you cannot chat ("..USERIP[player(id,"ip")]["mute"].." minutes)")
			return 1
		end
	end
)

addhook("minute","remove_temp_mute")
function remove_temp_mute()
	for _, id in pairs(player(0,"table")) do
		if USERIP[player(id,"ip")]["mute"] then
			USERIP[player(id,"ip")]["mute"] = USERIP[player(id,"ip")]["mute"] - 1
			if USERIP[player(id,"ip")]["mute"] <= 0 then
				USERIP[player(id,"ip")]["mute"] = nil
			end
		end
	end
end