﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace Cs2dRconViewer
{
    public class RconData
    {
        public string password;
        public string command;
        public int length;
        private int cnt;       
        public int type;
        public ColourRep clr;
        public List<textLine> output;

        //parses an array of bytes.
        //substracts the text lines
        public RconData(byte[] data, int length)
        {
            output = new List<textLine>();
            this.length = length;
            cnt = 3;
            
            while (cnt < length)
            {
                textLine a = new textLine();
                a.type = BitConverter.ToInt16(data, cnt); cnt += 2;
                a.length = BitConverter.ToInt16(data, cnt); cnt += 2;
                a.line = Encoding.ASCII.GetString(data, cnt, a.length);
                
                cnt += (a.length+1);
                if (a.type == 0x3401)
                    a.line = "Password is incorrect!";

                if (a.line.StartsWith("?"))
                {
                    ColourRep clr = new ColourRep(a.line.Substring(1, 9));
                    a.line = a.line.Substring(10);
                    a.color = clr.toColour();                    
                }
                output.Add(a);               
            }
        }

        public RconData(string password, string command)
        {
            this.password = password;
            this.command = command;
        }        

        // sets up the array to send
        public byte[] ToByte()
        {
            List<byte> result = new List<byte>();

            //First four are for the Command
            byte[] opcode = { 0x01, 0x00, 0xf2 };
            result.AddRange(opcode);

            //Add the length of the name
            if (password != null)
            {
                result.Add((byte)password.Length);
                result.AddRange(Encoding.ASCII.GetBytes(password));
            }

            if (command != null)
            {
                result.Add((byte)command.Length);
                result.Add(0x00);
                result.AddRange(Encoding.ASCII.GetBytes(command));
            }

            length = result.Count;

            return result.ToArray();
        }

        // adds colour to the text, not working yet. ©doesn't get send well.
        public void Colorize(int r, int g, int b)
        {
            ColourRep clr = new ColourRep(r, g, b);
            command = command.Insert(4, clr.toString());                
        }

    }

    

    public struct textLine
    {
        public textLine(short type, short length, string line)
        {
            this.type = type; this.length = length; this.line = line;
            color = Color.White;
        }
        public short type;
        public short length;
        public string line;
        public Color color;
    }
}
