﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;
using System.Diagnostics;

namespace Cs2dRconViewer
{
    public partial class Console : Form
    {
        public Socket clientSocket;
        public EndPoint epServer;
        public string rconPassword;
        byte[] byteData;

        public Console()
        {
            InitializeComponent();
            byteData = new byte[1024];

        }
        private void OnSend(IAsyncResult ar)
        {
            clientSocket.EndSend(ar);
        }

        private void OnReceive(IAsyncResult ar)
        {
            try
            {
                int length = clientSocket.EndReceive(ar);
                RconData rec = new RconData(byteData, length);
                foreach (textLine ln in rec.output)
                {
                    log(ln.line, ln.color);
                }                
            }
            catch (Exception ex)
            {
                log(ex.Message);
            }
            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                if (commandLine != null)
                {
                    string cmd = commandLine.Text;
                    RconData cmdToSend = new RconData(rconPassword, cmd);

                   /* if (isColorBox.Checked == true)
                    {
                        isColorBox.Checked = false;
                        cmdToSend.Colorize(
                            Int32.Parse(redBox.Text),
                            Int32.Parse(blueBox.Text),
                            Int32.Parse(greenBox.Text));

                    }*/
                    

                    clientSocket.BeginSendTo(cmdToSend.ToByte(), 0, cmdToSend.length, SocketFlags.None, epServer, new AsyncCallback(OnSend), null);

                    clientSocket.BeginReceiveFrom(byteData,
                                           0, byteData.Length,
                                           SocketFlags.None,
                                           ref epServer,
                                           new AsyncCallback(OnReceive),
                                           null);

                    commandLine.Text = null;
                }
            }
            catch (SocketException sock)
            {
                log("Server not online!");
            }            
        }

        private void log(string txt)
        {
            richTextBox1.AppendText(txt + "\r\n");                     
        }

        private void log(string txt, Color clr)
        {
            richTextBox1.SelectionColor = clr;
            richTextBox1.AppendText(txt + "\r\n");
            richTextBox1.ScrollToCaret();
        }

        private void commandLine_KeyPress(object sender, KeyPressEventArgs e)
        {
            
            if (e.KeyChar == (char)Keys.Return)
            {
                button1_Click(null, null);
            }
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AboutBox1 aboutBox1 = new AboutBox1();
            aboutBox1.Show();
        }

        private void quitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void disconnectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void commandsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Process.Start("cmd.txt");
        }
            
    }
}
