---------------------------
-- CUSTOM WEAPONS SCRIPT --
--     BY ENGIN33R       --
---------------------------

--[[
The code is not as clean as I would have liked to be, but it's not exactly meant to be modified extensively - if you do not understand something in this code,
write a comment on the file or, preferably, a PM to me directly. I'll try to help as much as I can.
]]

require "sys.core.libs.elib"

showwnames = true --set this to false if you do not want weapon names and ammunition to show upon hovering over them
hitmarkers = true --set this to false if you do not want CS2D-style red hit markers indicating direction of damage
optimize = false --set this to true if you want to optimize resource usage (atm changes always hook to ms100 hook)
weaponsounds = 100 --this is the radius in which generic weapon sounds are played (dropping, pickup, reloading)

weapons = {
	[1] = {
		name = "P250", --name
		sprite = "gfx/weapons/p250.png", --hold sprite
		sprited = "gfx/weapons/p250_d.png", --drop sprite
		snd = "weapons/glock18.wav", --sound
		range = 150, --range of bullet
		ammo = 13, --ammo in clip
		maxammo = 52, --carried ammo
		reloadt = 1500, --reload time
		sndrad = 400, --sound radius
		dmg = 11, --damage
		rid = 78, --real id; the actual weapon the player will have equipped
		disp = 3, --bullet dispersion
		burstmode = true, --burst mode available
		brf = 15, --burst fire bullets dispersion
	},
	[2] = {
		name = "ASR-2",
		sprite = "gfx/weapons/asr2_2.png",
		snd = "weapons/scout.wav",
		range = 300,
		ammo = 15,
		maxammo = 30,
		reloadt = 3000,
		sndrad = 400,
		dmg = 50,
		rid = 78,
		disp = 0,
		scope = {true,2}, --optical scope; [1] defines if scope exists on the weapon, [2] defines amount of zoom levels
		dmg1 = 60,
		dmg2 = 80,
		rfr = 2500,
	},
	[3] = {
		name = "PKP Pecheneg",
		sprite = "gfx/weapons/pkp.png",
		sprited = "gfx/weapons/pkp_d.png",
		snd = "weapons/pkp.wav",
		range = 500,
		ammo = 200,
		maxammo = 400,
		reloadt = 5000,
		sndrad = 400,
		dmg = 17,
		rid = 78,
		sph = 5, --shots per time unit
		ht = 500, --time unit for shots, in milliseconds
		disp = 20,
	},
	[4] = {
		name = "PKP Ammo", --name
		sprited = "gfx/weapons/ammobox.png", --dropped sprite
		type = "ammo", --system parameter to indicate that this is ammunition
		ammo = "full+", --ammo mode - replenish X carried ammo if a number, replenish all carried ammo if "full", replenish both carried ammo and clip ammo if "full+"
		weapon = 3, --weapon this ammunition is for (index in table)
	},
	[5] = {
		name = "M9",
		sprite = "gfx/weapons/p250.png",
		sprited = "gfx/weapons/p250_d.png",
		snd = "weapons/usp.wav",
		range = 200,
		ammo = 15,
		maxammo = 60,
		reloadt = 1750,
		sndrad = 400,
		dmg = 13,
		rid = 78,
		disp = 3,
		silencer = true, --silencer enabled
		sdmg = 11, --silenced damage
		srng = 150, --silenced range
		ssnd = "weapons/usp_silenced.wav", --silenced sound
		ssndrad = 200, --silenced sound radius
		sprites = "gfx/weapons/p250.png", --silenced sprite
	},
}

cwdata = {
	customweapons={{}},
	customweapon={},
	shootimg={},
	holdimg={},
	dmginf={},
	spages={},
	ssels={},
	ammoimg={{}},
	ammo={{}},
	reloading={},
	customdrops={{}},
	cursor={{}},
	wtable={},
	scopestate={},
	scopeimg={},
	refire={},
	burst={},
	silent={},
}

for i=1,32 do
	cwdata.customweapons[i]={}
	cwdata.ammoimg[i]={}
	cwdata.ammo[i]={}
	for w=1,#weapons do
		cwdata.ammo[i][w]={0,0}
	end
	cwdata.cursor[i]={}
	cwdata.scopestate[i]=0
	cwdata.silent[i]={}
end

if not oldplayer then oldplayer=player end
function player(id,str)
	if oldplayer(id,str) then
		return oldplayer(id,str)
	else
		if str=="cweapons" then
			return cwdata.customweapons[id]
		elseif str=="cweapon" then
			return cwdata.customweapon[id]
		end
	end
end

function CreateLineImage(X1,Y1,X2,Y2,w)
	local S = 32
	local D = math.sqrt((X2 - X1) * (X2 - X1) + (Y2 - Y1) * (Y2 - Y1))
	local A = math.atan2(Y2-Y1,X2-X1)
	X1 = X1 + math.cos(A) * (D / 2)
	Y1 = Y1 + math.sin(A) * (D / 2)
	local bulimg = weapons[w].bulimg or "gfx/weapons/bullet.png"
	local ID = image(bulimg,0,0,1,0)
	imagescale(ID,1,D / S)
	imagepos(ID,X1,Y1,math.deg(A)+90)
	tween_alpha(ID,100,0)
	timer(100,"parse","lua freeimage("..ID..")")
	return ID
end

function bufferimg(id,m) --I should really get rid of this in lieu of a better system.
	if m==0 then
		bimg=image("gfx/1by1.png",800,600,2,id)
		bimg2=image("gfx/1by1.png",800,600,2,id)
		bimg3=image("gfx/1by1.png",800,600,2,id)
		bimg4=image("gfx/1by1.png",800,600,2,id)
	else
		freeimage(bimg)
		freeimage(bimg2)
		freeimage(bimg3)
		freeimage(bimg4)
	end
end

function chit(id,src,dmg,cwpn) --hitting function
	local function cdmg(id,src,dmg,cwpn)
		if player(id,"health")>dmg then --if player has more health than the damage dealt
			parse("sethealth "..id.." "..player(id,"health")-dmg) --hurt him
		else
			parse("customkill "..src.." \""..weapons[cwpn].name.."\" "..id) --else, kill him
		end
		if hitmarkers then
			sang = -math.deg(math.atan2(player(id,"x")-player(src,"x"),player(id,"y")-player(src,"y"))) --angle between two players
			bufferimg(id,0) --create buffer images (must improve)
			if not cwdata.silent[src][player(id,"cweapon")] then
				local himg=image("gfx/hud_arrow.bmp",320,240,2,id) --the hit marker
				imageblend(himg,1) --image stuff: make blend light
				imagealpha(himg,0.5) --make alpha half
				imagecolor(himg,255,0,0) --make colour red
				tween_alpha(himg,1000,0) --in a second, make it disappear
				timer(1000,"parse","lua freeimage("..himg..")") --after a second, remove the image
				if sang>-45 and sang<=45 then --if it's the 90 degrees in front of the player, draw the image there
					imagepos(himg,320,190,180)
				elseif sang>45 and sang<=135 then --if it's the 90 degrees right of the player, draw the image there
					imagepos(himg,370,240,-90)
				elseif sang>135 and sang>=-135 then --if it's the 90 degrees below the player, draw the image there
					imagepos(himg,320,290,0)
				elseif sang>-135 and sang<=-45 then --if it's the 90 degrees left of the player, draw the image there
					imagepos(himg,270,240,90)
				end
			end
			bufferimg(id,1) --remove buffer images (must improve)
		end
	end
	if player(id,"team")==player(src,"team") then
		if game("sv_friendlyfire")=="1" then
			cdmg(id,src,dmg,cwpn)
		end
	else
		cdmg(id,src,dmg,cwpn)
	end
end

function checkallcw(id,wid)
	local n=0
	for _,cw in pairs(player(id,"cweapons")) do
		if weapons[cw].rid==wid then
			n=n+1
		end
	end
	return n
end

function managecw(id,mode,iid) -- System; Open cweapon management menu (called if a player selects a base weapon with 2 or more cweapons assigned to it)
	local p=1
	local paget=math.ceil(#player(id,"cweapons")/7)
	if not mode then mode="all" end
	for i=1,paget do
		if mode=="allwid" then
			cwdata.spages[i]="Choose Weapon Page "..i..","
		else
			cwdata.spages[i]="Weapon Management Page "..i..","
		end
		for ii=1,7 do
			local wid = ii+(7*(i-1))
			if player(id,"cweapons")[wid] then
				if mode=="allwid" then
					if weapons[player(id,"cweapons")[wid]].rid==iid then
						cwdata.spages[i]=cwdata.spages[i]..weapons[player(id,"cweapons")[wid]].name..","
						cwdata.ssels[wid]=player(id,"cweapons")[wid]
					end
				else
					cwdata.spages[i]=cwdata.spages[i]..weapons[player(id,"cweapons")[wid]].name..","
				end
			else
				if ii<7 then
					cwdata.spages[i]=cwdata.spages[i]..","
				else
					cwdata.spages[i]=cwdata.spages[i]..",,"
				end
			end
		end
		if i<paget then cwdata.spages[i]=cwdata.spages[i].."Next," end
		if i>1 then cwdata.spages[i]=cwdata.spages[i].."Back" end
	end
	if cwdata.spages[p] then
		menu(id,cwdata.spages[p])
	end
end

function cammo(id,wid,a) -- Give a ammo to player id's weapon wid (also accepts ammo modes; see above)
	if a=="full" then
		cwdata.ammo[id][wid][2]=weapons[wid].maxammo
	elseif a=="full+" then
		cwdata.ammo[id][wid][1]=weapons[wid].ammo
		cwdata.ammo[id][wid][2]=weapons[wid].maxammo
	else
		cwdata.ammo[id][wid][2]=cwdata.ammo[id][wid][2]+a
	end
end

function cequip(id,w,a,am) -- Equip weapon w to player id with a clip ammo and am carried ammo
	if not a then a=weapons[w].ammo end
	if not am then am=weapons[w].maxammo end
	if weapons[w].type~="ammo" then
		elib.insert2(cwdata.customweapons[id],w)
		if not cwdata.ammo[id] then cwdata.ammo[id]={} end
		cwdata.ammo[id][w]={a,am}
		if not elib.check(playerweapons(id),weapons[w].rid) then
			parse("equip "..id.." "..weapons[w].rid)
		end
		parse("setweapon "..id.." "..weapons[w].rid)
	else
		if type(weapons[w].weapon)=="number" then
			cammo(id,weapons[w].weapon,weapons[w].ammo,weapons[w].ammo)
		elseif type(weapons[w].weapon)=="table" then
			for _,wid in pairs(weapons[w].weapon) do
				cammo(id,wid,weapons[w].ammo,weapons[w].ammo)
			end
		end
	end
end

function cstrip(id,w) -- Strip weapon w from player id
	table.remove(cwdata.customweapons[id],elib.findintable(cwdata.customweapons[id],w))
end

function cdrop(id,w) -- Drop weapon w for palyer id
	table.remove(cwdata.customweapons[id],elib.findintable(cwdata.customweapons[id],w)) --remove weapon w from player's customweapons table
	if cwdata.holdimg[id] and cwdata.holdimg[id]~=0 then freeimage(cwdata.holdimg[id]) cwdata.holdimg[id]=0 end --remove holding image
	parse("setweapon "..id.." 50") --set weapon to knife after having dropped the cweapon
	elib.sound3("items/drop.wav",player(id,"x"),player(id,"y"),weaponsounds) --play dropping sound
	local k=elib.insert2(cwdata.customdrops,{image(weapons[w].sprited,player(id,"x"),player(id,"y"),0),w,player(id,"tilex"),player(id,"tiley"),cwdata.ammo[id][w][1],cwdata.ammo[id][w][2]})
	imagepos(cwdata.customdrops[k-1][1],player(id,"x"),player(id,"y"),math.random(1,360))
	cwdata.ammo[id][w][1],cwdata.ammo[id][w][2]=0,0
	if cwdata.customweapon[id] then
		cwdata.customweapon[id]=nil
		freeimage(cwdata.holdimg[id])
		cwdata.holdimg[id]=nil
	end
	if tonumber(game("mp_weaponfadeout"))>0 then
		timer(game("mp_weaponfadeout")*1000,"cfadeout",k-1)
	end
end

function cpickup(id,k) -- System; Pick up dropped weapon with ID k
	local w=cwdata.customdrops[k][2]
	cequip(id,w,cwdata.customdrops[k][5],cwdata.customdrops[k][6])
	freeimage(cwdata.customdrops[k][1])
	if weapons[w].type~="ammo" then
		elib.sound3("items/pickup.wav",player(id,"x"),player(id,"y"),weaponsounds)
	else
		elib.sound3("items/ammo.wav",player(id,"x"),player(id,"y"),weaponsounds)
	end
	cwdata.customdrops[k]=nil
end

function creload(id,w) -- System; Reload weapon w for player id
	if cwdata.ammo[id][w][1]+cwdata.ammo[id][w][2]>0 then
		if weapons[w].rsnd then
			if weapons[w].rsnd[1] then
				elib.sound3(weapons[w].rsnd[1],player(id,"x"),player(id,"y"),weaponsounds)
			else
				elib.sound3("weapons/w_clipout.wav",player(id,"x"),player(id,"y"),weaponsounds)
			end
			if weapons[w].rsnd[2] then
				elib.sound3(weapons[w].rsnd[2],player(id,"x"),player(id,"y"),weaponsounds)
			else
				timer(weapons[w].reloadt,"parse","lua elib.sound3(\"weapons/w_clipin.wav\",player("..id..",\"x\"),player("..id..",\"y\"),weaponsounds)")
			end
		else
			elib.sound3("weapons/w_clipout.wav",player(id,"x"),player(id,"y"),weaponsounds)
			timer(weapons[w].reloadt,"parse","lua elib.sound3(\"weapons/w_clipin.wav\",player("..id..",\"x\"),player("..id..",\"y\"),weaponsounds)")
		end
		cwdata.reloading[id]=true
		if cwdata.ammo[id][w][1]==0 then
			if cwdata.ammo[id][w][2]>=weapons[w].ammo then
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][1]="..weapons[w].ammo)
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][2]="..cwdata.ammo[id][w][2]-weapons[w].ammo)
			else
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][1]="..cwdata.ammo[id][w][1]+cwdata.ammo[id][w][2])
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][2]=0")
			end
		else
			if cwdata.ammo[id][w][2]>=weapons[w].ammo-cwdata.ammo[id][w][1] then
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][1]="..weapons[w].ammo)
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][2]="..cwdata.ammo[id][w][2]-(weapons[w].ammo-cwdata.ammo[id][w][1]))
			else
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][1]="..cwdata.ammo[id][w][1]+cwdata.ammo[id][w][2])
				timer(weapons[w].reloadt,"parse","lua cwdata.ammo["..id.."]["..w.."][2]=0")
			end
		end
		timer(weapons[w].reloadt,"parse","lua cwdata.reloading["..id.."]=false")
	end
end

function cfadeout(wid) -- System; Make weapon with ID wid fade out
	if wid then wid=tonumber(wid) end
	tween_alpha(cwdata.customdrops[wid][1],1000,0)
	timer(1000,"parse","lua freeimage("..cwdata.customdrops[wid][1]..")")
	cwdata.customdrops[wid]=nil
	for _,id in pairs(player(0,"table")) do
		if cwdata.wtable[id] then
			freeimage(cwdata.wtable[id])
			cwdata.wtable[id]=nil
			elib.hudtxt2(id,30,"","",0,0)
		end
	end
end

function cspawn(w,x,y,a,am) -- Spawn weapon w on position X|Y (tiles) with a ammo in clip and am carried ammo
	if not a then a=weapons[w].ammo end
	if not am then am=weapons[w].maxammo end
	local k=elib.insert2(cwdata.customdrops,{image(weapons[w].sprited,x*32+16,y*32+16,0),w,x,y,a,am})
	imagepos(cwdata.customdrops[k-1][1],x*32+16,y*32+16,math.random(1,360))
end

function cscope(id,w) -- System; Scope in with weapon w for player id
	if weapons[w].scope and weapons[w].scope[1] then
		if (cwdata.scopestate[id]<weapons[w].scope[2]) then
			if cwdata.scopeimg[id] then freeimage(cwdata.scopeimg[id]) end
			bufferimg(id,0)
			cwdata.scopestate[id]=cwdata.scopestate[id]+1
			cwdata.scopeimg[id]=image("gfx/weapons/scope"..cwdata.scopestate[id]..".png",cwdata.cursor[id][1],cwdata.cursor[id][2],2,id)
			msg(cwdata.scopeimg[id])
			bufferimg(id,1)
		else
			cwdata.scopestate[id]=0
			freeimage(cwdata.scopeimg[id])
			cwdata.scopeimg[id]=nil
		end
		elib.sound3("weapons/zoom.wav",player(id,"x"),player(id,"y"),100)
	end
end

function cburst(id,w) -- System; Toggle burst-fire mode on weapon w for player id
	if weapons[w].burstmode then
		if not cwdata.burst[id] then
			cwdata.burst[id]=true
			msg2(id,"burst-mode on@C")
			elib.sound3("weapons/click.wav",player(id,"x"),player(id,"y"),100)
		else
			cwdata.burst[id]=false
			msg2(id,"burst-mode off@C")
			elib.sound3("weapons/click.wav",player(id,"x"),player(id,"y"),100)
		end
	end
end

function chitcheck(id,w,r1,r2,rot) -- System; the actual function making shots - images, sounds, damage
	local ww=w --make ww weapon id;
	local w=weapons[w] --make w point to the actual weapon table
	local xr = math.random(-(w.disp/2),w.disp/2) --a random angle for dispersion
	local rrot --shot rotation
	local done --checking done
	local range --shot range
	if not cwdata.silent[id][ww] then --if a silencer range is specified, use that instead of the default one
		range=w.range
	else
		range=w.srng
	end
	if not rot then --if the rot argument wasn't specified, set the shot rotation to the player's rotation + the random dispersion angle modifier
		rrot=player(id,"rot")+xr
	else
		rrot=rot
	end
	for r=1,range-1 do
		r1,r2 = elib.angledir(rrot,r1,r2,1) --set initial point to check
		if not tile(math.floor(r1/32),math.floor(r2/32),"wall") then --if not a wall then continue
			if r<range then --if the point being checked is not outside of the shot range
				for _,iid in pairs(player(0,"table")) do
					if iid~=id and elib.inrange(iid,r1,r2,16) then --check if shot hits any player in a 16-px radius circle
						if not cwdata.scopestate[id] or cwdata.scopestate[id]==0 or not w.scope[1] then --if the weapon isn't scoped
							if not cwdata.silent[id][ww] then --if the weapon isn't silenced
								chit(iid,id,w.dmg,ww) --do normal damage
							else
								chit(iid,id,w.sdmg,ww) --do silenced damage
							end
						else
							chit(iid,id,w["dmg"..cwdata.scopestate[id]],ww) --do scope damage
						end
						elib.sound3("player/hit"..math.random(1,3)..".wav",r1,r2,100) --play hit sound
						done=true --checking done!
						break --break up
					end
				end
				if done then break end --brehk dis wan tew
			else
				break --break up (it's a beeeeeeeeat)
			end
		else
			break -- SO MANY BREAKS, AHHH
		end
	end
	bufferimg(id,0) --create some buffer images
	cwdata.shootimg[id]=CreateLineImage(player(id,"x"),player(id,"y"),r1,r2,ww) --create shot
	bufferimg(id,1) --remove created buffer images
	cwdata.ammo[id][ww][1]=cwdata.ammo[id][ww][1]-1 --subtract ammo
	if not cwdata.silent[id][ww] then--if not silenced,
		elib.sound3(w.snd,player(id,"x"),player(id,"y"),w.sndrad) --play the normal shot sound in the normal range
	else --if it is silenced,
		if w.ssndrad then --if the silenced sound radius is specified
			elib.sound3(w.ssnd,player(id,"x"),player(id,"y"),w.ssndrad) --play the silenced shot sound in the silenced range
		else
			elib.sound3(w.ssnd,player(id,"x"),player(id,"y"),w.sndrad) --else play the silenced shot sound in the normal range
		end
	end
end

function csil(id,w) -- toggle silencer on weapon w for player id
	if weapons[w].silencer then
		if not cwdata.silent[id][w] then
			msg2(id,"silencer on@C")
			elib.sound3("weapons/silencer_on.wav",player(id,"x"),player(id,"y"),100)
			cwdata.silent[id][w]=true
			cwdata.refire[id]=true
			timer(1000,"parse","lua cwdata.refire["..id.."]=false")
			if cwdata.holdimg[id] then
				freeimage(cwdata.holdimg[id])
				cwdata.holdimg[id]=image(weapons[w].sprites,1,0,200+id)
			end
		else
			cwdata.burst[id]=false
			msg2(id,"silencer off@C")
			elib.sound3("weapons/silencer_off.wav",player(id,"x"),player(id,"y"),100)
			cwdata.silent[id][w]=false
			cwdata.refire[id]=true
			timer(1000,"parse","lua cwdata.refire["..id.."]=false")
			if cwdata.holdimg[id] then
				freeimage(cwdata.holdimg[id])
				cwdata.holdimg[id]=image(weapons[w].sprite,1,0,200+id)
			end
		end
	end
end

---- SYSTEM FUNCTIONS ----

function customweaponf(id) --Function to fire a weapon
	local ww=player(id,"cweapon") --ww is now the current custom weapon id
	local w=weapons[ww] --w is now pointing to the entry of that weapon in the weapons table
	if player(id,"weapon")==w.rid then --if the player's weapon id is the real id of the custom one
		local xr = math.random(-(w.disp/2),w.disp/2) --random angle modifier for dispersion
		local rrot=player(id,"rot")+xr --shot rotation
		local r1,r2 = elib.angledir(player(id,"rot")+xr,player(id,"x"),player(id,"y"),1) --initial point of shot
		local br11,br12,br21,br22 --burst fire variables (positions of right and left shots in the 3-shot salvo)
		local brot1,brot2 --burst fire variables (rotations of right and left shots in the 3-shot salvo)
		if cwdata.burst[id] then
			brot1,brot2 = player(id,"rot")+w.brf,player(id,"rot")-w.brf --setting the rots
			br11,br12 = elib.angledir(player(id,"rot")+w.brf,player(id,"x"),player(id,"y"),1) --setting the right positions
			br21,br22 = elib.angledir(player(id,"rot")-w.brf,player(id,"x"),player(id,"y"),1) --setting the left positions
			if cwdata.ammo[id][ww][1]>3 then
				chitcheck(id,ww,r1,r2,rrot) --check hit for middle shot
				chitcheck(id,ww,br11,br12,brot1) --check hit for right shot
				chitcheck(id,ww,br21,br22,brot2) --check hit for left shot
			else
				for i=1,cwdata.ammo[id][ww][1] do
					chitcheck(id,ww,r1,r2,rrot) --fire as many middle shots as there are bullets in the clip left
				end
				if not cwdata.reloading[id] then creload(id,ww) end --reload
			end
		else
			if cwdata.ammo[id][ww][1]>0 then
				chitcheck(id,ww,r1,r2,rrot) --fire a middle shot
			else
				cwdata.ammo[id][ww][1]=0 --set ammo to zero
				if not cwdata.reloading[id] then creload(id,ww) end --reload
			end
		end
	end
end

--[[
The rest doesn't matter as much, I'll comment it more extensively in later revisions
]]

addhook("attack","customweaponff")
function customweaponff(id)
	if player(id,"cweapon") then
		if cwdata.ammo[id][player(id,"cweapon")][1]>0 then
			if not cwdata.refire[id] then
				if weapons[player(id,"cweapon")].ht then
					timer((weapons[player(id,"cweapon")].ht/weapons[player(id,"cweapon")].sph),"parse","lua customweaponf("..id..")",weapons[player(id,"cweapon")].sph) --if there should be more than 1 shots per attack, calculate how many milliseconds apart they should be and shoot
				else
					customweaponf(id) --otherwise just fire
				end
				if weapons[player(id,"cweapon")].rfr then --if it has a refire rate, engage
					cwdata.refire[id]=true
					timer(weapons[player(id,"cweapon")].rfr,"parse","lua cwdata.refire["..id.."]=false")
				end
			end
		end
	end
end

addhook("attack2","customweaponspecial")
function customweaponspecial(id)
	if player(id,"cweapon") then --if the player has a custom weapon out
		cscope(id,player(id,"cweapon")) --try scoping
		cburst(id,player(id,"cweapon")) --if that don't work, try engaging burst mode
		csil(id,player(id,"cweapon")) --if that don't work, try engaging silenced mode
	end
end

addhook("select","switchtocw") --switching to custom weapons
function switchtocw(id,w)
	if cwdata.customweapon[id] then freeimage(cwdata.holdimg[id]) end --if there's already one being held, remove its image
	for _,cw in pairs(player(id,"cweapons")) do
		if weapons[cw].rid==w then --if the weapon being switched to is a base for a custom weapon
			if checkallcw(id,w)==1 then --if there's only one custom weapon on the player assigned to the base w
				bufferimg(id,0) --engage buffer images (bleh, should make a better workaround)
				cwdata.customweapon[id]=cw --set current custom weapon to the one assigned to the base
				if not cwdata.customweapon[id] then freeimage(cwdata.holdimg[id]) end
				if not cwdata.silent[id][ww] then --if the weapon isn't silenced, use the default sprite
					cwdata.holdimg[id]=image(weapons[cw].sprite,1,0,200+id)
				else --otherwise use the silenced sprite
					cwdata.holdimg[id]=image(weapons[cw].sprites,1,0,200+id)
				end
				bufferimg(id,1) --disengage buffer images
				break --break up (but I love to hear that crazy beat)
			else
				managecw(id,"allwid",w) --if there's more than one weapon assigned to the base w, open a menu to choose which one the player wants
				break --break up (gets the people dancing on their feet)
			end
		else --if the weapon being switched to isn't a base for a cweapon
			if cwdata.customweapon[id] then --if there's a cweapon in hand, remove it
				cwdata.customweapon[id]=nil
				freeimage(cwdata.holdimg[id])
				cwdata.holdimg[id]=nil
			end
		end
	end
end

addhook("say","cwmanage",10128) --unfortunately there isn't a way to check for a reload attempt - the reload hook only registers legit reloading
function cwmanage(id,t)
	if (t=="cwr") then --if you write 'cwr' in the chat, the weapon is reloaded
		if player(id,"cweapon") then
			creload(id,player(id,"cweapon"))
		end
		return 1
	end
end

addhook("menu","cwmanagem")
function cwmanagem(id,menu,sel)
	if menu:sub(1,13)=="Choose Weapon" then --parse the choice menu!
		local page=tonumber(menu:sub(20,21)) --get the page number
		local gsel=sel+(7*(page-1)) --calculate the global item ID
		cwdata.customweapon[id]=cwdata.ssels[gsel] --set the custom weapon to the one chosen
		bufferimg(id,0)
		if cwdata.holdimg[id] then freeimage(cwdata.holdimg[id]) end --if there's already an in-hand image, remove it
		cwdata.holdimg[id]=image(weapons[cwdata.ssels[gsel]].sprite,1,0,200+id) --
		bufferimg(id,1)
	end
end

function cwdata.ammoimgs(id,am,amx)
	am=tostring(am);
	amx=tostring(amx);
	for _,img in pairs(cwdata.ammoimg[id]) do
		freeimage(img)
	end
	cwdata.ammoimg[id]={}
	if (player(id,"cweapon")) then
		local c=am:len()
		local i=1
		while c>0 do
			local dam=am:sub(c,c);
			cwdata.ammoimg[id][i]=image("gfx/weapons/nums/hud_nums_0"..dam..".png",555-(22*(i-1)),462,2,id);
			imagescale(cwdata.ammoimg[id][i],0.8,0.8);
			imagecolor(cwdata.ammoimg[id][i],103,103,0);
			imageblend(cwdata.ammoimg[id][i],1);
			i=i+1
			c=c-1
		end
		cwdata.ammoimg[id][100] = image("gfx/weapons/nums/bar.png",581,462,2,id);
		imagescale(cwdata.ammoimg[id][100],0.8,0.8);
		imagecolor(cwdata.ammoimg[id][100],103,103,0);
		imageblend(cwdata.ammoimg[id][100],1);
		c=amx:len()
		i=1
		while c>0 do
			local damx=amx:sub(c,c);
			cwdata.ammoimg[id][i+am:len()]=image("gfx/weapons/nums/hud_nums_0"..damx..".png",646-(22*i),462,2,id);
			imagescale(cwdata.ammoimg[id][i+am:len()],0.8,0.8);
			imagecolor(cwdata.ammoimg[id][i+am:len()],103,103,0);
			imageblend(cwdata.ammoimg[id][i+am:len()],1);
			i=i+1
			c=c-1
		end
	end
end
	
if optimize then
	addhook("ms100","drawfunc")
else
	addhook("always","drawfunc")
end
function drawfunc()
	for _,id in pairs(player(0,"tableliving")) do
		if player(id,"cweapon") then
			cwdata.ammoimgs(id,cwdata.ammo[id][player(id,"cweapon")][1],cwdata.ammo[id][player(id,"cweapon")][2]);
			if cwdata.ammo[id][player(id,"cweapon")][1]==0 and not cwdata.reloading[id] then
				creload(id,player(id,"cweapon"))
			end
			if cwdata.scopestate[id]>0 then
				imagepos(cwdata.scopeimg[id],cwdata.cursor[id][1],cwdata.cursor[id][2],0)
			end
		else
			cwdata.ammoimgs(id,1000,1000);
		end
	end
	if showwnames then
		reqcld(0,0)
		reqcld(0,2)
	end
end

addhook("drop","cdropf",100)
function cdropf(id,iid,type)
	if player(id,"cweapon") then
		if type==weapons[player(id,"cweapon")].rid then
			cdrop(id,player(id,"cweapon"))
			parse("strip "..id.." "..type)
			return 1
		end
	end
end

addhook("movetile","cpickupf")
function cpickupf(id,x,y)
	for k,dw in pairs(cwdata.customdrops) do
		if x==dw[3] and y==dw[4] then
			cpickup(id,k)
			if cwdata.wtable[id] then
				freeimage(cwdata.wtable[id])
				cwdata.wtable[id]=nil
				elib.hudtxt2(id,30,"","",0,0)
			end
		end
	end
end

if showwnames then
addhook("clientdata","weaponinfos")
function weaponinfos(id,m,a1,a2)
	if m==0 then
		if player(id,"exists") then
			cwdata.cursor[id][1],cwdata.cursor[id][2]=a1,a2
		end
	end
	if m==2 then
		if player(id,"exists") then
			for _,w in pairs(cwdata.customdrops) do
				if #w>0 then
					if elib.distance(a1,a2,w[3]*32+16,w[4]*32+16)<=32 then
						if cwdata.wtable[id] then freeimage(cwdata.wtable[id]) end
						cwdata.wtable[id]=image("gfx/1by1.png",cwdata.cursor[id][1],cwdata.cursor[id][2]+16,2,id)
						local ammot
						local colour=""
						local stringtp
						if weapons[w[2]].type~="ammo" then
							if w[5]==0 and w[6]==0 then
								ammot="empty"
								colour="255000000"
							else
								ammot=w[5].."|"..w[6]
							end
							stringtp=weapons[w[2]].name.." ("..ammot..")"
						else
							stringtp=weapons[w[2]].name
						end
						imagescale(cwdata.wtable[id],(stringtp:len()*9),15)
						imagecolor(cwdata.wtable[id],55,55,55)
						imagealpha(cwdata.wtable[id],0.6)
						elib.hudtxt2(id,30,colour,stringtp,cwdata.cursor[id][1],cwdata.cursor[id][2]+8,1)
					else
						if cwdata.wtable[id] then
							freeimage(cwdata.wtable[id])
							cwdata.wtable[id]=nil
							elib.hudtxt2(id,30,"","",0,0)
						end
					end
				end
			end
		end
	end
end
end

addhook("parse","cwcmds")
function cwcmds(cmd)
	local ocmd=cmd
	cmd=elib.split(cmd,"%S+")
	if cmd[1]=="cequip" then
		cequip(tonumber(cmd[2]),tonumber(cmd[3]),tonumber(cmd[4]),tonumber(cmd[5]))
		return 2
	end
	if cmd[1]=="cstrip" then
		cstrip(tonumber(cmd[2]),tonumber(cmd[3]))
		return 2
	end
	if cmd[1]=="cspawn" then
		cequip(tonumber(cmd[2]),tonumber(cmd[3]),tonumber(cmd[4]),tonumber(cmd[5]),tonumber(cmd[6]))
		return 2
	end
end

addhook("rcon","cwrcmds")
function cwrcmds(cmd)
	if cwcmds(cmd)==2 then
		return 1
	end
end