-------------------------------------------
---          ENGIN33R PRESENTS          ---
---  ELIB - UNIVERSAL CS2D LUA LIBRARY  ---
---      VERSION 1.6 (27 MAY 2012)      ---
-------------------------------------------


elib={}
setmetatable(_G,{__index=elib})

------ TABLE FUNCTIONS ------

-- elib.eliminate(table,element)
-- Eliminate all 'element' from 'table'
function elib.eliminate(t,el)
	local r = {}
	for k,v in pairs(t) do
		if v~=el then
			r[#r+1] = v
		end
	end
	return r
end

function elib.tblprint(t)
	local str=""
	for _,v in ipairs(t) do
		if (str=="") then
			str=str..v
		else
			str=str..","..v
		end
	end
	return str
end

function elib.array(f)
	local cmd={}
	for c=1,f do
		cmd[c]=0
	end
	return cmd
end

function elib.array2(f,v)
	local cmd={}
	for c=1,f do
		cmd[c]=v
	end
	return cmd
end

function elib.doublearray(m,n,k)
    local a, x, y = {}
    for x = 0, m do a[x] = {}
        for y = 0, n do
            a[x][y] = k
        end
    end
    return a
end

function elib.check(table,element)
    for _,value in ipairs(table) do
        if value==element then
            return true
        end
    end
    return false
end

function elib.findintable(table, element)
    for key,value in ipairs(table) do
        if value==element then
            return key
        end
    end
    return nil
end

function elib.insert2(table,element)
	for key,value in ipairs(table) do
		if (value==nil) then
			table[key]=element
			return key
		end
	end
	table[#table+1]=element
	return #table+1
end

function elib.glookup(element)
	for key,value in pairs(_G) do
		if (value==element) then
			return key
		end
	end
	return nil
end

function elib.moveindices(table,margin)
	for k,v in pairs(table) do
		if type(k)=="number" then
			table[k+margin]=table[k]
			table[k]=nil
		end
	end
end

------ MATH FUNCTIONS ------

function elib.percent(n,p)
	if p==0 then return n end
	return (n/100)*p
end

function elib.round(n,d)
	if d and d>0 then
		local m=10^d
		return math.floor(n*m+0.5)/m
	end
	return math.floor(n+0.5)
end

function elib.angledir(rot,x,y,factor)
	if rot<-90 then rot=rot+360 end
	local angle=math.rad(math.abs(rot+90))-math.pi
	local cx=x+(math.cos(angle)*factor)
	local cy=y+(math.sin(angle)*factor)
	return cx,cy
end

function elib.hextodecconvert(hex)
	local hd={0,1,2,3,4,5,6,7,8,9,["a"]=10,["b"]=11,["c"]=12,["d"]=13,["e"]=14,["f"]=15}
	local l=hex:len()
	local c=l
	local p=0
	local r=0
	repeat
		r=r+(hd[hex:lower():sub(c,c)]*(16^p))
		c=c-1
		p=p+1
	until c==0
	return r
end

function elib.bintodecconvert(bin)
	local l=tostring(bin):len()
	local c=l
	local p=0
	local r=0
	repeat
		r=r+(tonumber(tostring(bin):sub(c,c))*(2^p))
		c=c-1
		p=p+1
	until c==0
	return r
end

------ LOGIC FUNCTIONS ------

function elib.tobool(v)
	if v==false or v==nil or v=="" or v==0 then return false end
	return true
end

function elib.strtobool(v)
	if v=="false" then return false elseif v=="true" then return true end
end

function elib.xor(a,b)
	local ab=elib.tobool(a)
	local bb=elib.tobool(b)
	if a~=b then return true else return false end
end

function elib.nand(a,b)
	local ab=elib.tobool(a)
	local bb=elib.tobool(b)
	if ab==false or bb==false then return false else return true end
end

function elib.nor(a,b)
	local ab=elib.tobool(a)
	local bb=elib.tobool(b)
	if ab==false and bb==false then return true else return false end
end

------ STRING FUNCTIONS ------

function elib.split(split,pat)
	local t = {}
	for item in string.gmatch(split, pat) do
		if item~="" then
			table.insert(t,item)
		end
	end
	return t
end

------ GAME FUNCTIONS ------

colors = {
	["red"] = "255000000",
	["green"] = "000255000",
	["blue"] = "000000255",
	["yellow"] = "255255000",
	["cyan"] = "000255255",
	["purple"] = "255000255",
	["white"] = "255255255",
	["black"] = "000000000",
	["gray"] = "125125125",
	["darkgray"] = "055055055",
	["lightgray"] = "175175175",
}

-- ATTENTION: Colors as words DON'T WORK! It's still experimental, please do not use them unless you fixed them.
function elib.hudtxt2(id,idt,color,text,x,y,align)
	if not align then align=0 end
	for i=1,#colors do
		if (colors[color]) then
			color=colors[color]
		end
	end
	local toprint
	if color~="" then
		toprint=""..color.." "..text
	else
		toprint=text
	end
	parse('hudtxt2 '..id..' '..idt..' "'..toprint..'" '..x.." "..y.." "..align)
end

function elib.cmsg(txt,color)
	for i=1,#colors do
		if (colors[color]) then
			print(color)
			print(colors[color])
			color=colors[color]
		end
	end
	print(color)
	print(colors[color])
	msg(""..color..txt)
end

function elib.cmsg2(txt,id,color)
	for i=1,#colors do
		if (colors[color]) then
			color=colors[color]
		end
	end
	msg2(id,""..color..txt)
end

function elib.pxconvert(x,y)
	return ((x*32)+16),((y*32)+16)
end

function elib.tileconvert(x,y)
	return math.floor(x/32),math.floor(y/32)
end

function elib.msg3(message, x, y, r, id) -- thanks to JetFighter::
	for key, value in ipairs(player(0, "tableliving")) do
		local dx, dy = player(value, "x") - x, player(value, "y") - y
		local distance = math.sqrt(dx * dx + dy * dy)
		if distance < r then
			msg2(value, player(value, "name")..": "..message)
		end
	end
end

function elib.sound3(sound,x,y,r) -- thanks to JetFighter::
    for key, value in ipairs(player(0, "tableliving")) do
		local dx, dy = player(value, "x") - x, player(value, "y") - y
		local distance = math.sqrt(dx * dx + dy * dy)
		if distance < r then
			parse("sv_sound2 "..value.." \""..sound.."\"")
		end
	end
end

function elib.inrange(id,x,y,r)
	local dx,dy=player(id,"x")-x,player(id,"y")-y
	local distance=math.sqrt(dx*dx+dy*dy)
	if distance<r then
		return true
	end
	return false
end

function elib.distance(x1,y1,x2,y2)
	local dx,dy=x1-x2,y1-y2
	local distance=math.sqrt(dx*dx+dy*dy)
	return distance
end

function elib.allinrange(x,y,r)
	local ids={}
	for _,id in pairs(player(0,"table")) do
		local dx,dy=player(id,"x")-x,player(id,"y")-y
		local distance=math.sqrt(dx*dx+dy*dy)
		if distance<r then
			ids[#ids+1]=id
		end
	end
	return ids
end

print("ELib initialized successfully!")